%{
/*
 * XR16 machine description file.
 *
 * Portions copyright (C) 1999, 2000, Gray Research LLC.  All rights reserved.
 * Portions of this file are subject to the XSOC License Agreement;
 * you may not use them except in compliance with this Agreement.
 * See the LICENSE file.
 *
 * This work is derived from the original src/mips.md file in the
 * lcc4.1 distribution.  See the CPYRIGHT file.
 *
 * Registers    Use
 * r0           zero; unchangeable
 * r1           reserved for the assembler
 * r2           function return value
 * r3-r5        first function arg(s)
 * r6-r9        scratch registers
 * r10-r12      register variables
 * r13          stack pointer
 * r14          interrupt return address (reserved)
 * r15          return address
 * 
 * Operator terminals generated by ops c=1 s=2 i=2 l=4 h=4 f=4 d=4 x=4 p=2
 *
 * Floating point is not implemented.
 */

#define INTTMP 0x03C0
#define INTVAR 0x1C00
#define FLTTMP 0x000f0ff0
#define FLTVAR 0xfff00000

#define INTRET 0x0004
#define FLTRET 0x00000003

#define NUM_IREGS       16
#define REG_RETVAL      2       /* r2: return value */
#define REG_FIRST_ARG   3       /* r3: first argument register */
#define REG_LAST_ARG    5       /* r5: last argument register */
#define REG_FIRST_TEMP  6       /* r6: first temp register */
#define SZ_REG_FIRST_TEMP "6"   /* r6: first temp register */
#define REG_LAST_TEMP   9       /* r9: last temp register */
#define REG_SP          13      /* r13, sp: stack pointer */
#define REG_RETADDR     15      /* r15: return address */
#define NUM_ARG_REGS    (REG_LAST_ARG - REG_FIRST_ARG + 1)

#define INT_CALLEE_SAVE (INTVAR | ((unsigned)1 << REG_RETADDR))

#define readsreg(p) \
        (generic((p)->op)==INDIR && (p)->kids[0]->op==VREG+P)
#define setsrc(d) ((d) && (d)->x.regnode && \
        (d)->x.regnode->set == src->x.regnode->set && \
        (d)->x.regnode->mask&src->x.regnode->mask)

#define relink(a, b) ((b)->x.prev = (a), (a)->x.next = (b))

#include "c.h"
#include <time.h>

#define NODEPTR_TYPE Node
#define OP_LABEL(p) ((p)->op)
#define LEFT_CHILD(p) ((p)->kids[0])
#define RIGHT_CHILD(p) ((p)->kids[1])
#define STATE_LABEL(p) ((p)->x.state)
static void address(Symbol, Symbol, long);
static void blkfetch(int, int, int, int);
static void blkloop(int, int, int, int, int, int[]);
static void blkstore(int, int, int, int);
static void defaddress(Symbol);
static void defconst(int, int, Value);
static void defstring(int, char *);
static void defsymbol(Symbol);
static void doarg(Node);
static void emit2(Node);
static void export(Symbol);
static void clobber(Node);
static void function(Symbol, Symbol [], Symbol [], int);
static void global(Symbol);
static void import(Symbol);
static void local(Symbol);
static void progbeg(int, char **);
static void progend(void);
static void segment(int);
static void space(int);
static void target(Node);
static int fp();
static int      bitcount       (unsigned);
static Symbol   argreg         (int, int, int, int, int);

static Symbol ireg[32], lreg[32], freg2[32], r3r4, r4r5;
static Symbol iregw, lregw, freg2w;
static int tmpregs[] = {1, REG_FIRST_TEMP+1, REG_FIRST_TEMP+2};
static Symbol blkreg;

static int gnum = 8;

static int cseg;
%}

%start stmt

%term CNSTF4=4113
%term CNSTI1=1045 CNSTI2=2069 CNSTI4=4117
%term CNSTP2=2071
%term CNSTU1=1046 CNSTU2=2070 CNSTU4=4118

%term ARGB=41
%term ARGF4=4129
%term ARGI2=2085 ARGI4=4133
%term ARGP2=2087
%term ARGU2=2086 ARGU4=4134

%term ASGNB=57
%term ASGNF4=4145
%term ASGNI1=1077 ASGNI2=2101 ASGNI4=4149
%term ASGNP2=2103
%term ASGNU1=1078 ASGNU2=2102 ASGNU4=4150

%term INDIRB=73
%term INDIRF4=4161
%term INDIRI1=1093 INDIRI2=2117 INDIRI4=4165
%term INDIRP2=2119
%term INDIRU1=1094 INDIRU2=2118 INDIRU4=4166

%term CVFF4=4209
%term CVFI2=2165 CVFI4=4213

%term CVIF4=4225
%term CVII1=1157 CVII2=2181 CVII4=4229
%term CVIU1=1158 CVIU2=2182 CVIU4=4230

%term CVPU2=2198

%term CVUI1=1205 CVUI2=2229 CVUI4=4277
%term CVUP2=2231
%term CVUU1=1206 CVUU2=2230 CVUU4=4278

%term NEGF4=4289
%term NEGI2=2245 NEGI4=4293

%term CALLB=217
%term CALLF4=4305
%term CALLI2=2261 CALLI4=4309
%term CALLP2=2263
%term CALLU2=2262 CALLU4=4310
%term CALLV=216

%term RETF4=4337
%term RETI2=2293 RETI4=4341
%term RETP2=2295
%term RETU2=2294 RETU4=4342
%term RETV=248

%term ADDRGP2=2311

%term ADDRFP2=2327

%term ADDRLP2=2343

%term ADDF4=4401
%term ADDI2=2357 ADDI4=4405
%term ADDP2=2359
%term ADDU2=2358 ADDU4=4406

%term SUBF4=4417
%term SUBI2=2373 SUBI4=4421
%term SUBP2=2375
%term SUBU2=2374 SUBU4=4422

%term LSHI2=2389 LSHI4=4437
%term LSHU2=2390 LSHU4=4438

%term MODI2=2405 MODI4=4453
%term MODU2=2406 MODU4=4454

%term RSHI2=2421 RSHI4=4469
%term RSHU2=2422 RSHU4=4470

%term BANDI2=2437 BANDI4=4485
%term BANDU2=2438 BANDU4=4486

%term BCOMI2=2453 BCOMI4=4501
%term BCOMU2=2454 BCOMU4=4502

%term BORI2=2469 BORI4=4517
%term BORU2=2470 BORU4=4518

%term BXORI2=2485 BXORI4=4533
%term BXORU2=2486 BXORU4=4534

%term DIVF4=4545
%term DIVI2=2501 DIVI4=4549
%term DIVU2=2502 DIVU4=4550

%term MULF4=4561
%term MULI2=2517 MULI4=4565
%term MULU2=2518 MULU4=4566

%term EQF4=4577
%term EQI2=2533 EQI4=4581
%term EQU2=2534 EQU4=4582

%term GEF4=4593
%term GEI2=2549 GEI4=4597
%term GEU2=2550 GEU4=4598

%term GTF4=4609
%term GTI2=2565 GTI4=4613
%term GTU2=2566 GTU4=4614

%term LEF4=4625
%term LEI2=2581 LEI4=4629
%term LEU2=2582 LEU4=4630

%term LTF4=4641
%term LTI2=2597 LTI4=4645
%term LTU2=2598 LTU4=4646

%term NEF4=4657
%term NEI2=2613 NEI4=4661
%term NEU2=2614 NEU4=4662

%term JUMPV=584

%term LABELV=600

%term LOADB=233
%term LOADF4=4321
%term LOADI1=1253 LOADI2=2277 LOADI4=4325
%term LOADP2=2279
%term LOADU1=1254 LOADU2=2278 LOADU4=4326

%term VREGP=711
%%
reg:  INDIRI1(VREGP)     "# read register\n"
reg:  INDIRU1(VREGP)     "# read register\n"

reg:  INDIRI2(VREGP)     "# read register\n"
reg:  INDIRU2(VREGP)     "# read register\n"

reg:  INDIRF4(VREGP)     "# read register\n" fp()
reg:  INDIRI4(VREGP)     "# read register\n"
reg:  INDIRP2(VREGP)     "# read register\n"
reg:  INDIRU4(VREGP)     "# read register\n"

stmt: ASGNI1(VREGP,reg)  "# write register\n"
stmt: ASGNU1(VREGP,reg)  "# write register\n"

stmt: ASGNI2(VREGP,reg)  "# write register\n"
stmt: ASGNU2(VREGP,reg)  "# write register\n"
stmt: ASGNP2(VREGP,reg)  "# write register\n"

stmt: ASGNF4(VREGP,reg)  "# write register\n" fp()
stmt: ASGNI4(VREGP,reg)  "# write register\n"
stmt: ASGNU4(VREGP,reg)  "# write register\n"

con: CNSTI1  "%a"
con: CNSTU1  "%a"
con: CNSTI2  "%a"
con: CNSTU2  "%a"
con: CNSTP2  "%a"


reg: CNSTI4   "leal r%c,%a\n"  2
reg: CNSTU4   "leal r%c,%a\n"  2

stmt: reg  ""
acon: con     "%0"
acon: ADDRGP2 "%a"
addr: ADDI2(reg,acon)  "%1(r%0)"
addr: ADDU2(reg,acon)  "%1(r%0)"
addr: ADDP2(reg,acon)  "%1(r%0)"
addr: acon  "%0"
addr: reg   "(r%0)"
addr: ADDRFP2  "%a+%F(sp)"
addr: ADDRLP2  "%a+%F(sp)"
reg: addr  "lea r%c,%0\n"  1
reg: CNSTI1  "# reg\n"  range(a, 0, 0)
reg: CNSTI2  "# reg\n"  range(a, 0, 0)
reg: CNSTI4  "# reg\n"  range(a, 0, 0)
reg: CNSTU1  "# reg\n"  range(a, 0, 0)
reg: CNSTU2  "# reg\n"  range(a, 0, 0)
reg: CNSTU4  "# reg\n"  range(a, 0, 0)
reg: CNSTP2  "# reg\n"  range(a, 0, 0)
stmt: ASGNI1(addr,reg)  "sb r%1,%0\n"  1
stmt: ASGNU1(addr,reg)  "sb r%1,%0\n"  1
stmt: ASGNI2(addr,reg)  "sw r%1,%0\n"  1
stmt: ASGNU2(addr,reg)  "sw r%1,%0\n"  1
stmt: ASGNI4(addr,reg)  "sl r%1,%0\n"  1
stmt: ASGNU4(addr,reg)  "sl r%1,%0\n"  1
stmt: ASGNP2(addr,reg)  "sw r%1,%0\n"  1
reg:  INDIRI1(addr)     "lbs r%c,%0\n"  1
reg:  INDIRU1(addr)     "lb r%c,%0\n"  1
reg:  INDIRI2(addr)     "lw r%c,%0\n"  1
reg:  INDIRU2(addr)     "lw r%c,%0\n"  1
reg:  INDIRI4(addr)     "ll r%c,%0\n"  1
reg:  INDIRU4(addr)     "ll r%c,%0\n"  1
reg:  INDIRP2(addr)     "lw r%c,%0\n"  1

reg:  CVII2(INDIRI1(addr))     "lbs r%c,%0\n"  1
reg:  CVUU2(INDIRU1(addr))     "lb r%c,%0\n"  1
reg:  CVUI2(INDIRU1(addr))     "lb r%c,%0\n"  1
reg:  CVII4(INDIRI1(addr))     "lbsl r%c,%0\n"  1
reg:  CVII4(INDIRI2(addr))     "lwsl r%c,%0\n"  1
reg:  CVUU4(INDIRU1(addr))     "lbul r%c,%0\n"  1
reg:  CVUU4(INDIRU2(addr))     "lwul r%c,%0\n"  1
reg:  CVUI4(INDIRU1(addr))     "lbul r%c,%0\n"  1
reg:  CVUI4(INDIRU2(addr))     "lwul r%c,%0\n"  1
reg:  INDIRF4(addr)     "# fp\n"  fp()
stmt: ASGNF4(addr,reg)  "# fp\n"  fp()
reg: DIVI2(reg,reg)  "call _divi2\n"   1
reg: DIVI4(reg,reg)  "call _divi4\n"   1
reg: DIVU2(reg,reg)  "call _divu2\n"  1
reg: DIVU4(reg,reg)  "call _divu4\n"  1
reg: MODI2(reg,reg)  "call _modi2\n"   1
reg: MODI4(reg,reg)  "call _modi4\n"   1
reg: MODU2(reg,reg)  "call _modu2\n"  1
reg: MODU4(reg,reg)  "call _modu4\n"  1
reg: MULI2(reg,reg)  "call _muli2\n"   1
reg: MULI4(reg,reg)  "call _muli4\n"   1
reg: MULU2(reg,reg)  "call _mulu2\n"   1
reg: MULU4(reg,reg)  "call _mulu4\n"   1

reg: ADDI2(reg,reg)   "add r%c,r%0,r%1\n"  1
reg: ADDI4(reg,reg)   "addl r%c,r%0,r%1\n"  1
reg: ADDP2(reg,reg)   "add r%c,r%0,r%1\n"  1
reg: ADDU2(reg,reg)   "add r%c,r%0,r%1\n"  1
reg: ADDU4(reg,reg)   "addl r%c,r%0,r%1\n"  1
reg: BANDI2(reg,reg)  "?mov r%c,r%0\nand r%c,r%1\n"   1
reg: BANDI4(reg,reg)  "?movl r%c,r%0\nandl r%c,r%1\n"   1
reg: BORI2(reg,reg)   "?mov r%c,r%0\nor r%c,r%1\n"    1
reg: BORI4(reg,reg)   "?movl r%c,r%0\norl r%c,r%1\n"    1
reg: BXORI2(reg,reg)  "?mov r%c,r%0\nxor r%c,r%1\n"   1
reg: BXORI4(reg,reg)  "?movl r%c,r%0\nxorl r%c,r%1\n"   1
reg: BANDU2(reg,reg)  "?mov r%c,r%0\nand r%c,r%1\n"   1
reg: BANDU4(reg,reg)  "?movl r%c,r%0\nandl r%c,r%1\n"   1
reg: BORU2(reg,reg)   "?mov r%c,r%0\nor r%c,r%1\n"    1
reg: BORU4(reg,reg)   "?movl r%c,r%0\norl r%c,r%1\n"    1
reg: BXORU2(reg,reg)  "?mov r%c,r%0\nxor r%c,r%1\n"   1
reg: BXORU4(reg,reg)  "?movl r%c,r%0\nxorl r%c,r%1\n"   1
reg: SUBI2(reg,reg)   "sub r%c,r%0,r%1\n"  1
reg: SUBI4(reg,reg)   "subl r%c,r%0,r%1\n"  1
reg: SUBP2(reg,reg)   "sub r%c,r%0,r%1\n"  1
reg: SUBU2(reg,reg)   "sub r%c,r%0,r%1\n"  1
reg: SUBU4(reg,reg)   "subl r%c,r%0,r%1\n"  1

reg: ADDI2(reg,con)   "addi r%c,r%0,%1\n"  1
reg: ADDI4(reg,con)   "addil r%c,r%0,%1\n"  1
reg: ADDP2(reg,con)   "addi r%c,r%0,%1\n"  1
reg: ADDU2(reg,con)   "addi r%c,r%0,%1\n"  1
reg: ADDU4(reg,con)   "addil r%c,r%0,%1\n"  1
reg: BANDI2(reg,con)  "?mov r%c,r%0\nandi r%c,%1\n"   1
reg: BANDI4(reg,con)  "?movl r%c,r%0\nandil r%c,%1\n"   1
reg: BORI2(reg,con)   "?mov r%c,r%0\nori r%c,%1\n"    1
reg: BORI4(reg,con)   "?movl r%c,r%0\noril r%c,%1\n"    1
reg: BXORI2(reg,con)  "?mov r%c,r%0\nxori r%c,%1\n"   1
reg: BXORI4(reg,con)  "?movl r%c,r%0\nxoril r%c,%1\n"   1
reg: BANDU2(reg,con)  "?mov r%c,r%0\nandi r%c,%1\n"   1
reg: BANDU4(reg,con)  "?movl r%c,r%0\nandil r%c,%1\n"   1
reg: BORU2(reg,con)   "?mov r%c,r%0\nori r%c,%1\n"    1
reg: BORU4(reg,con)   "?movl r%c,r%0\noril r%c,%1\n"    1
reg: BXORU2(reg,con)  "?mov r%c,r%0\nxori r%c,%1\n"   1
reg: BXORU4(reg,con)  "?movl r%c,r%0\nxoril r%c,%1\n"   1
reg: SUBI2(reg,con)   "subi r%c,r%0,%1\n"  1
reg: SUBI4(reg,con)   "subil r%c,r%0,%1\n"  1
reg: SUBP2(reg,con)   "subi r%c,r%0,%1\n"  1
reg: SUBU2(reg,con)   "subi r%c,r%0,%1\n"  1
reg: SUBU4(reg,con)   "subil r%c,r%0,%1\n"  1

reg: LSHI2(reg,reg)  "call _sllr\n"  10
reg: LSHI4(reg,reg)  "call _slllr\n"  10
reg: LSHU2(reg,reg)  "call _sllr\n"  10
reg: LSHU4(reg,reg)  "call _slllr\n"  10
reg: RSHI2(reg,reg)  "call _srar\n"  10
reg: RSHI4(reg,reg)  "call _sralr\n"  10
reg: RSHU2(reg,reg)  "call _srlr\n"  10
reg: RSHU4(reg,reg)  "call _srllr\n"  10

reg: LSHI2(reg,con)  "?mov r%c,r%0\nslli r%c,%1\n"  1
reg: LSHI4(reg,con)  "?movl r%c,r%0\nsllil r%c,%1\n"  1
reg: LSHU2(reg,con)  "?mov r%c,r%0\nslli r%c,%1\n"  1
reg: LSHU4(reg,con)  "?movl r%c,r%0\nsllil r%c,%1\n"  1
reg: RSHI2(reg,con)  "?mov r%c,r%0\nsrai r%c,%1\n"  1
reg: RSHI4(reg,con)  "?movl r%c,r%0\nsrail r%c,%1\n"  1
reg: RSHU2(reg,con)  "?mov r%c,r%0\nsrli r%c,%1\n"  1
reg: RSHU4(reg,con)  "?movl r%c,r%0\nsrlil r%c,%1\n"  1

reg: BCOMI2(reg)  "?mov r%c,r%0\nxori r%c,-1\n"   1
reg: BCOMI4(reg)  "?movl r%c,r%0\nxoril r%c,-1\n"   1
reg: BCOMU2(reg)  "?mov r%c,r%0\nxori r%c,-1\n"   1
reg: BCOMU4(reg)  "?movl r%c,r%0\nxoril r%c,-1\n"   1
reg: NEGI2(reg)   "sub r%c,r0,r%0\n"  1
reg: NEGI4(reg)   "subl r%c,r0,r%0\n"  1
reg: LOADI1(reg)  "mov r%c,r%0\n"  move(a)
reg: LOADU1(reg)  "mov r%c,r%0\n"  move(a)
reg: LOADI2(reg)  "mov r%c,r%0\n"  move(a)
reg: LOADU2(reg)  "mov r%c,r%0\n"  move(a)
reg: LOADI4(reg)  "mov r%c,r%0\n"  move(a)
reg: LOADP2(reg)  "mov r%c,r%0\n"  move(a)
reg: LOADU4(reg)  "mov r%c,r%0\n"  move(a)
reg: ADDF4(reg,reg)  ""  fp()
reg: DIVF4(reg,reg)  ""  fp()
reg: MULF4(reg,reg)  ""  fp()
reg: SUBF4(reg,reg)  ""  fp()
reg: LOADF4(reg)     ""       move(a)+fp()
reg: NEGF4(reg)      ""  fp()
reg: CVII2(reg)  "sext r%c,r%0\n"  1
reg: CVUI2(reg)  "zext r%c,r%0\n"  1
reg: CVUU2(reg)  "zext r%c,r%0\n"  1
reg: CVII4(reg)  "sexl r%c,r%0\n"  1
reg: CVIU4(reg)  "sexl r%c,r%0\n"  1
reg: CVUI4(reg)  "zexl r%c,r%0\n"  1
reg: CVUU4(reg)  "zexl r%c,r%0\n"  1
reg: CVFF4(reg)  ""  fp()
reg: CVIF4(reg)  ""  fp()
reg: CVFI2(reg)  ""  fp()
reg: CVFI4(reg)  ""  fp()
stmt: LABELV  "%a:\n"
stmt: JUMPV(acon)  "br %0\n"   1
stmt: JUMPV(reg)   "jal r0,0(r%0)\n"  1

stmt: EQI2(reg,reg)  "cmp r%0,r%1\nbeq %a\n"   2
stmt: EQI4(reg,reg)  "cmpl r%0,r%1\nbeq %a\n"   2
stmt: EQU2(reg,reg)  "cmp r%0,r%1\nbeq %a\n"   2
stmt: EQU4(reg,reg)  "cmpl r%0,r%1\nbeq %a\n"   2
stmt: GEI2(reg,reg)  "cmp r%0,r%1\nbge %a\n"   2
stmt: GEI4(reg,reg)  "cmpl r%0,r%1\nbge %a\n"   2
stmt: GEU2(reg,reg)  "cmp r%0,r%1\nbgeu %a\n"  2
stmt: GEU4(reg,reg)  "cmpl r%0,r%1\nbgeu %a\n"  2
stmt: GTI2(reg,reg)  "cmp r%0,r%1\nbgt %a\n"   2
stmt: GTI4(reg,reg)  "cmpl r%0,r%1\nbgt %a\n"   2
stmt: GTU2(reg,reg)  "cmp r%0,r%1\nbgtu %a\n"  2
stmt: GTU4(reg,reg)  "cmpl r%0,r%1\nbgtu %a\n"  2
stmt: LEI2(reg,reg)  "cmp r%0,r%1\nble %a\n"   2
stmt: LEI4(reg,reg)  "cmpl r%0,r%1\nble %a\n"   2
stmt: LEU2(reg,reg)  "cmp r%0,r%1\nbleu %a\n"  2
stmt: LEU4(reg,reg)  "cmpl r%0,r%1\nbleu %a\n"  2
stmt: LTI2(reg,reg)  "cmp r%0,r%1\nblt %a\n"   2
stmt: LTI4(reg,reg)  "cmpl r%0,r%1\nblt %a\n"   2
stmt: LTU2(reg,reg)  "cmp r%0,r%1\nbltu %a\n"  2
stmt: LTU4(reg,reg)  "cmpl r%0,r%1\nbltu %a\n"  2
stmt: NEI2(reg,reg)  "cmp r%0,r%1\nbne %a\n"   2
stmt: NEI4(reg,reg)  "cmpl r%0,r%1\nbne %a\n"   2
stmt: NEU2(reg,reg)  "cmp r%0,r%1\nbne %a\n"   2
stmt: NEU4(reg,reg)  "cmpl r%0,r%1\nbne %a\n"   2

stmt: EQI2(reg,con)  "cmpi r%0,%1\nbeq %a\n"   2
stmt: EQI4(reg,con)  "cmpil r%0,%1\nbeq %a\n"   2
stmt: EQU2(reg,con)  "cmpi r%0,%1\nbeq %a\n"   2
stmt: EQU4(reg,con)  "cmpil r%0,%1\nbeq %a\n"   2
stmt: GEI2(reg,con)  "cmpi r%0,%1\nbge %a\n"   2
stmt: GEI4(reg,con)  "cmpil r%0,%1\nbge %a\n"   2
stmt: GEU2(reg,con)  "cmpi r%0,%1\nbgeu %a\n"  2
stmt: GEU4(reg,con)  "cmpil r%0,%1\nbgeu %a\n"  2
stmt: GTI2(reg,con)  "cmpi r%0,%1\nbgt %a\n"   2
stmt: GTI4(reg,con)  "cmpil r%0,%1\nbgt %a\n"   2
stmt: GTU2(reg,con)  "cmpi r%0,%1\nbgtu %a\n"  2
stmt: GTU4(reg,con)  "cmpil r%0,%1\nbgtu %a\n"  2
stmt: LEI2(reg,con)  "cmpi r%0,%1\nble %a\n"   2
stmt: LEI4(reg,con)  "cmpil r%0,%1\nble %a\n"   2
stmt: LEU2(reg,con)  "cmpi r%0,%1\nbleu %a\n"  2
stmt: LEU4(reg,con)  "cmpil r%0,%1\nbleu %a\n"  2
stmt: LTI2(reg,con)  "cmpi r%0,%1\nblt %a\n"   2
stmt: LTI4(reg,con)  "cmpil r%0,%1\nblt %a\n"   2
stmt: LTU2(reg,con)  "cmpi r%0,%1\nbltu %a\n"  2
stmt: LTU4(reg,con)  "cmpil r%0,%1\nbltu %a\n"  2
stmt: NEI2(reg,con)  "cmpi r%0,%1\nbne %a\n"   2
stmt: NEI4(reg,con)  "cmpil r%0,%1\nbne %a\n"   2
stmt: NEU2(reg,con)  "cmpi r%0,%1\nbne %a\n"   2
stmt: NEU4(reg,con)  "cmpil r%0,%1\nbne %a\n"   2

stmt: EQF4(reg,reg)  ""  fp()
stmt: LEF4(reg,reg)  ""  fp()
stmt: LTF4(reg,reg)  ""  fp()
stmt: GEF4(reg,reg)  ""  fp()
stmt: GTF4(reg,reg)  ""  fp()
stmt: NEF4(reg,reg)  ""  fp()
ar:   ADDRGP2     "%a"

reg:  CALLF4(ar)  "call %0\n"  fp()
reg:  CALLI2(ar)  "call %0\n"  1
reg:  CALLI4(ar)  "call %0\n"  1
reg:  CALLP2(ar)  "call %0\n"  1
reg:  CALLU2(ar)  "call %0\n"  1
reg:  CALLU4(ar)  "call %0\n"  1
stmt: CALLV(ar)  "call %0\n"  1
ar: reg    "r%0"
ar: CNSTP2  "%a"   range(a, 0, 0x0ffff)
stmt: RETF4(reg)  "# ret\n"  fp()
stmt: RETI2(reg)  "# ret\n"  1
stmt: RETI4(reg)  "# ret\n"  1
stmt: RETU2(reg)  "# ret\n"  1
stmt: RETU4(reg)  "# ret\n"  1
stmt: RETP2(reg)  "# ret\n"  1
stmt: RETV(reg)   "# ret\n"  1
stmt: ARGF4(reg)  "# arg\n"  fp()
stmt: ARGI2(reg)  "# arg\n"  1
stmt: ARGI4(reg)  "# arg\n"  1
stmt: ARGP2(reg)  "# arg\n"  1
stmt: ARGU2(reg)  "# arg\n"  1
stmt: ARGU4(reg)  "# arg\n"  1

stmt: ARGB(INDIRB(reg))       "# argb %0\n"      1
stmt: ASGNB(reg,INDIRB(reg))  "# asgnb %0 %1\n"  1
%%
static void progend(void){}
static void progbeg(int argc, char *argv[]) {
        int i;
        time_t now;
        struct tm* ptmNow;
        static char rev[] = "$Revision: 3 $";
 
        {
                union {
                        char c;
                        int i;
                } u;
                u.i = 0;
                u.c = 1;
                swap = ((int)(u.i == 1)) != IR->little_endian;
        }

        time(&now);
        ptmNow = localtime(&now);
        rev[strlen(rev)-2] = 0;
        printf("; generated by lcc-xr16 rev.%s on %s\n", rev+11, asctime(ptmNow));

        parseflags(argc, argv);
        for (i = 0; i < argc; i++)
                if (strncmp(argv[i], "-G", 2) == 0)
                        gnum = atoi(argv[i] + 2);
        for (i = 0; i < NUM_IREGS; i++)
                ireg[i] = mkreg("%d", i, 1, IREG);
        ireg[REG_SP]->x.name = "sp";
        for (i = 0; i < NUM_IREGS; i += 2)
                lreg[i] = mkreg("%d", i, 3, IREG);
        for (i = 0; i < 31; i += 2)
                freg2[i] = mkreg("%d", i, 3, FREG);

        r3r4 = mkreg("3", 3, 3, IREG);
        r4r5 = mkreg("4", 4, 3, IREG);

        freg2w = mkwildcard(freg2);
        iregw = mkwildcard(ireg);
        lregw = mkwildcard(lreg);
        tmask[IREG] = INTTMP; tmask[FREG] = FLTTMP;
        vmask[IREG] = INTVAR; vmask[FREG] = FLTVAR;
        blkreg = mkreg(SZ_REG_FIRST_TEMP, REG_FIRST_TEMP, 7, IREG);
}
static Symbol rmap(int opk) {
        switch (optype(opk)) {
        case I: case U:
                return (opsize(opk) == 4) ? lregw : iregw;
        case P: case B:
                return iregw;
        case F:
                fp();
                return freg2w;
        default:
                return 0;
        }
}
static void target(Node p) {
        assert(p);
        switch (specific(p->op)) {
        case CNST+I: case CNST+U: case CNST+P:
                if (range(p, 0, 0) == 0) {
                        setreg(p, ireg[0]);
                        p->x.registered = 1;
                }
                break;
        case CALL+V:
                break;
        case CALL+F:
                setreg(p, freg2[0]);
                break;
        case CALL+I: case CALL+P: case CALL+U:
                setreg(p, ireg[REG_RETVAL]);
                break;
        case RET+F:
                rtarget(p, 0, freg2[0]);
                break;
        case RET+I: case RET+U: case RET+P:
                rtarget(p, 0, ireg[REG_RETVAL]);
                break;
        case ARG+F: case ARG+I: case ARG+P: case ARG+U: {
                static int ty0;
                int ty = optype(p->op);
                Symbol q;

                q = argreg(p->x.argno, p->syms[2]->u.c.v.i, ty, opsize(p->op), ty0);
                if (p->x.argno == 0)
                        ty0 = ty;
                if (q &&
                !(ty == F && q->x.regnode->set == IREG))
                        rtarget(p, 0, q);
                break;
                }
        case ASGN+B: rtarget(p->kids[1], 0, blkreg); break;
        case ARG+B:  rtarget(p->kids[0], 0, blkreg); break;
        case DIV+I: case MOD+I: case MUL+I:
        case DIV+U: case MOD+U: case MUL+U:
        /* REVIEW: LSH, RSH? */
                assert(REG_FIRST_ARG+1 <= REG_LAST_ARG);
                setreg(p, ireg[REG_RETVAL]);
                rtarget(p, 0, ireg[REG_FIRST_ARG]);
                rtarget(p, 1, ireg[REG_FIRST_ARG+1]);
                break;
        }
}
static void clobber(Node p) {
        assert(p);
        switch (specific(p->op)) {
        case CALL+F:
                spill(INTTMP | INTRET, IREG, p);
                spill(FLTTMP,          FREG, p);
                break;
        case CALL+I: case CALL+P: case CALL+U:
                spill(INTTMP,          IREG, p);
                spill(FLTTMP | FLTRET, FREG, p);
                break;
        case CALL+V:
                spill(INTTMP | INTRET, IREG, p);
                spill(FLTTMP | FLTRET, FREG, p);
                break;
        }
}
static void emit2(Node p) {
        int dst, n, src, sz, ty;
        static int ty0;
        Symbol q;

        switch (specific(p->op)) {
        case ARG+F: case ARG+I: case ARG+P: case ARG+U:
                ty = optype(p->op);
                sz = opsize(p->op);
                if (p->x.argno == 0)
                        ty0 = ty;
                q = argreg(p->x.argno, p->syms[2]->u.c.v.i, ty, sz, ty0);
                src = getregnum(p->x.kids[0]);
                if (q == NULL && ty == F && sz == 4)
                        print("s.s rf%d,%d(sp)\n", src, p->syms[2]->u.c.v.i);
                else if (q == NULL && ty == F)
                        print("s.d rf%d,%d(sp)\n", src, p->syms[2]->u.c.v.i);
                else if (q == NULL)
                        print("s%c r%d,%d(sp)\n", "wl"[sz==4], src, p->syms[2]->u.c.v.i);
                else if (ty == F && sz == 4 && q->x.regnode->set == IREG)
                        print("mfc1 r%d,rf%d\n", q->x.regnode->number, src);
                else if (ty == F && q->x.regnode->set == IREG)
                        print("mfc1.d r%d,rf%d\n", q->x.regnode->number, src);
                break;
        case ASGN+B:
                dalign = salign = p->syms[1]->u.c.v.i;
                blkcopy(getregnum(p->x.kids[0]), 0,
                        getregnum(p->x.kids[1]), 0,
                        p->syms[0]->u.c.v.i, tmpregs);
                break;
        case ARG+B:
                dalign = 4;
                salign = p->syms[1]->u.c.v.i;
                blkcopy(REG_SP, p->syms[2]->u.c.v.i,
                        getregnum(p->x.kids[0]), 0,
                        p->syms[0]->u.c.v.i, tmpregs);
                n   = p->syms[2]->u.c.v.i + p->syms[0]->u.c.v.i;
                dst = p->syms[2]->u.c.v.i;
                for ( ; dst <= (4*(NUM_ARG_REGS-1)) && dst < n; dst += 4)
                        print("lw r%d,%d(sp)\n", (dst/4)+4, dst);
                break;
        }
}
static Symbol argreg(int argno, int offset, int ty, int sz, int ty0) {
        assert((offset&1) == 0);
        if (offset + sz > 2*NUM_ARG_REGS || !(ty == I || ty == U || ty == P))
                return NULL;
        else if (argno == 0 && sz == 4)
                return r3r4;
        else if (argno == 1 && sz == 4)
                return r4r5;
        else
                return ireg[(offset/2) + REG_FIRST_ARG];
}
static void doarg(Node p) {
        static int argno;
        int align;

        if (argoffset == 0)
                argno = 0;
        p->x.argno = argno++;
        align = p->syms[1]->u.c.v.i < 2 ? 2 : p->syms[1]->u.c.v.i;
        p->syms[2] = intconst(mkactual(align,
                p->syms[0]->u.c.v.i));
}
static void local(Symbol p) {
        if (askregvar(p, rmap(ttob(p->type))) == 0)
                mkauto(p);
}
static void function(Symbol f, Symbol caller[], Symbol callee[], int ncalls) {
        int i, saved, sizefsave, sizeisave, varargs;
        Symbol r, argregs[NUM_ARG_REGS];

        usedmask[0] = usedmask[1] = 0;
        freemask[0] = freemask[1] = ~(unsigned)0;
        offset = maxoffset = maxargoffset = 0;
        for (i = 0; callee[i]; i++)
                ;
        varargs = variadic(f->type)
                || i > 0 && strcmp(callee[i-1]->name, "va_alist") == 0;
        for (i = 0; callee[i]; i++) {
                Symbol p = callee[i];
                Symbol q = caller[i];
                assert(q);
                offset = roundup(offset, q->type->align);
                p->x.offset = q->x.offset = offset;
                p->x.name = q->x.name = stringd(offset);
                r = argreg(i, offset, optype(ttob(q->type)), q->type->size, optype(ttob(caller[0]->type)));
                if (i < NUM_ARG_REGS)
                        argregs[i] = r;
                offset = roundup(offset + q->type->size, 2);
                if (varargs)
                        p->sclass = AUTO;
                else if (r && ncalls == 0 &&
                         !isstruct(q->type) && !p->addressed &&
                         !(isfloat(q->type) && r->x.regnode->set == IREG)
) {
                        p->sclass = q->sclass = REGISTER;
                        askregvar(p, r);
                        assert(p->x.regnode && p->x.regnode->vbl == p);
                        q->x = p->x;
                        q->type = p->type;
                }
                else if (askregvar(p, rmap(ttob(p->type)))
                         && r != NULL
                         && (isint(p->type) || p->type == q->type)) {
                        assert(q->sclass != REGISTER);
                        p->sclass = q->sclass = REGISTER;
                        q->type = p->type;
                }
        }
        assert(!caller[i]);
        offset = 0;
        gencode(caller, callee);
        if (ncalls)
                usedmask[IREG] |= ((unsigned)1)<<REG_RETADDR;
        usedmask[IREG] &= INT_CALLEE_SAVE;
        usedmask[FREG] &= 0xfff00000;
        maxargoffset = roundup(maxargoffset, usedmask[FREG] ? 8 : 2);
        if (ncalls && maxargoffset < NUM_ARG_REGS*2)
                maxargoffset = NUM_ARG_REGS*2;
        sizefsave = 4*bitcount(usedmask[FREG]);
        sizeisave = 2*bitcount(usedmask[IREG]);
        framesize = roundup(maxargoffset + sizefsave
                + sizeisave + maxoffset, 2);
        segment(CODE);
        printf("align 16\n");
        printf("%s:\n", f->x.name);
        i = maxargoffset + sizefsave - framesize;
        if (framesize > 0)
                print("addi sp,sp,%d\n", -framesize);
        saved = maxargoffset;
        for (i = 20; i <= 30; i += 2)
                if (usedmask[FREG]&(3<<i)) {
                        print("s.d rf%d,%d(sp)\n", i, saved);
                        saved += 8;
                }

        for (i = 0; i < NUM_IREGS; i++)
                if (usedmask[IREG]&(1<<i)) {
                        print("sw r%d,%d(sp)\n", i, saved);
                        saved += 2;
                }
        for (i = 0; i < NUM_ARG_REGS && callee[i]; i++) {
                r = argregs[i];
                if (r && r->x.regnode != callee[i]->x.regnode) {
                        Symbol out = callee[i];
                        Symbol in  = caller[i];
                        int rn = r->x.regnode->number;
                        int rs = r->x.regnode->set;
                        int tyin = ttob(in->type);

                        assert(out && in && r && r->x.regnode);
                        assert(out->sclass != REGISTER || out->x.regnode);
                        if (out->sclass == REGISTER
                        && (isint(out->type) || out->type == in->type)) {
                                int outn = out->x.regnode->number;
                                if (rs == FREG && tyin == F+sizeop(8))
                                        print("mov.d rf%d,rf%d\n", outn, rn);
                                else if (rs == FREG && tyin == F+sizeop(4))
                                        print("mov.s rf%d,rf%d\n", outn, rn);
                                else if (rs == IREG && tyin == F+sizeop(8))
                                        print("mtc1.d r%d,rf%d\n", rn,   outn);
                                else if (rs == IREG && tyin == F+sizeop(4))
                                        print("mtc1 r%d,rf%d\n",   rn,   outn);
                                else
                                        print("mov r%d,r%d\n",    outn, rn);
                        } else {
                                int off = in->x.offset + framesize;
                                if (rs == FREG && tyin == F+sizeop(8))
                                        print("s.d rf%d,%d(sp)\n", rn, off);
                                else if (rs == FREG && tyin == F+sizeop(4))
                                        print("s.s rf%d,%d(sp)\n", rn, off);
                                else {
                                        int i, n = (in->type->size + 1)/2;
                                        for (i = rn; i < rn+n && i <= REG_LAST_ARG; i++)
                                                print("sw r%d,%d(sp)\n", i, off + (i-rn)*2);
                                }
                        }
                }
        }
        if (varargs && callee[i-1]) {
                i = callee[i-1]->x.offset + callee[i-1]->type->size;
                for (i = roundup(i, 2)/2; i < NUM_ARG_REGS; i++)
                        print("sw r%d,%d(sp)\n", REG_FIRST_ARG + i, framesize + 2*i);
                }
        emitcode();
        saved = maxargoffset;
        for (i = 20; i <= 30; i += 2)
                if (usedmask[FREG]&(3<<i)) {
                        print("l.d rf%d,%d(sp)\n", i, saved);
                        saved += 8;
                }
        for (i = 0; i < NUM_IREGS; i++)
                if (usedmask[IREG]&(1<<i)) {
                        print("lw r%d,%d(sp)\n", i, saved);
                        saved += 2;
                }
        if (framesize > 0)
                print("addi sp,sp,%d\n", framesize);
        print("ret\n\n");
}
static void defconst(int suffix, int size, Value v) {
        if (suffix == F)
                fp();
        else if (suffix == P)
                print("word %u\n", v.p);
        else if (size == 1)
                print("byte %u\n", suffix == I ? v.i : v.u);
        else if (size == 2)
                print("word %u\n", suffix == I ? v.i : v.u);
        else if (size == 4)
                print("dword %u\n", suffix == I ? v.i : v.u);
}
static void defaddress(Symbol p) {
        print("word %s\n", p->x.name);
}
static void defstring(int n, char *str) {
        char *s;

        for (s = str; s < str + n; s++)
                print("byte %d\n", (*s)&0377);
}
static void export(Symbol p) {
        print("global %s\n", p->x.name);
}
static void import(Symbol p) {
        if (!isfunc(p->type))
                print("global %s\n", p->x.name); /* good enough? */
}
static void defsymbol(Symbol p) {
        if (p->scope >= LOCAL && p->sclass == STATIC)
                p->x.name = stringf("L%d", genlabel(1));
        else if (p->generated)
                p->x.name = stringf("L%s", p->name);
        else if (p->scope == GLOBAL || p->sclass == EXTERN)
                p->x.name = stringf("_%s", p->name);
        else
                assert(p->scope != CONSTANTS || isint(p->type) || isptr(p->type)),
                p->x.name = p->name;
}
static void address(Symbol q, Symbol p, long n) {
        if (p->scope == GLOBAL
        || p->sclass == STATIC || p->sclass == EXTERN)
                q->x.name = stringf("%s%s%D", p->x.name,
                        n >= 0 ? "+" : "", n);
        else {
                assert(n <= INT_MAX && n >= INT_MIN);
                q->x.offset = p->x.offset + n;
                q->x.name = stringd(q->x.offset);
        }
}
static void global(Symbol p) {
        if (p->type->align > 1)
                print("align %d\n", p->type->align);
        print("%s:\n", p->x.name);
        if (p->u.seg == BSS)
                printf("bss %d\n", p->type->size);
}
static void segment(int n) {
        cseg = n;
}
static void space(int n) {
        if (cseg != BSS)
                print("space %d\n", n);
}
static void blkloop(int dreg, int doff, int sreg, int soff, int size, int tmps[]) {
        int lab = genlabel(1);

        print("addi r%d,r%d,%d\n", sreg, sreg, size&~7);
        print("addi r%d,r%d,%d\n", tmps[2], dreg, size&~7);
        blkcopy(tmps[2], doff, sreg, soff, size&7, tmps);
        print("L%d:\n", lab);
        print("addi r%d,r%d,%d\n", sreg, sreg, -8);
        print("addi r%d,r%d,%d\n", tmps[2], tmps[2], -8);
        blkcopy(tmps[2], doff, sreg, soff, 8, tmps);
        print("cmp r%d,r%d\nbltu L%d\n", dreg, tmps[2], lab);
}
static void blkfetch(int size, int off, int reg, int tmp) {
        assert(size == 1 || size == 2);
        if (size == 1)
                print("lb r%d,%d(r%d)\n",  tmp, off, reg);
        else {
                assert(salign >= size);
                print("lw r%d,%d(r%d)\n",   tmp, off, reg);
        }
}
static void blkstore(int size, int off, int reg, int tmp) {
        assert(size == 1 || size == 2);
        if (size == 1)
                print("sb r%d,%d(r%d)\n",  tmp, off, reg);
        else {
                assert(dalign >= size);
                print("sw r%d,%d(r%d)\n",  tmp, off, reg);
        }
}
static void stabinit(char *, int, char *[]);
static void stabline(Coordinate *);
static void stabsym(Symbol);

static char *currentfile;

static int bitcount(unsigned mask) {
        unsigned i, n = 0;

        for (i = 1; i; i <<= 1)
                if (mask&i)
                        n++;
        return n;
}

/* stabinit - initialize stab output */
static void stabinit(char *file, int argc, char *argv[]) {
        if (file) {
                print("file \"%s\"\n", file);
                currentfile = file;
        }
}

/* stabline - emit stab entry for source coordinate *cp */
static void stabline(Coordinate *cp) {
        if (cp->file && cp->file != currentfile) {
                print("file \"%s\"\n", cp->file);
                currentfile = cp->file;
        }
        print("loc %d\n", cp->y);
}

/* stabsym - output a stab entry for symbol p */
static void stabsym(Symbol p) {
        if (p == cfunc && IR->stabline)
                (*IR->stabline)(&p->src);
}

static int fp() {
    static int err = 0;
    if (!err) {
        err = 1;
        error("floating point not implemented\n");
    }
    return 2;
}

Interface xr16IR = {
        1, 1, 0,  /* char */
        2, 2, 0,  /* short */
        2, 2, 0,  /* int */
        4, 4, 0,  /* long */
        4, 4, 0,  /* long long */
        4, 4, 1,  /* float */
        4, 4, 1,  /* double */
        4, 4, 1,  /* long double */
        2, 2, 0,  /* T * */
        0, 2, 0,  /* struct */
        0,  /* little_endian */
        1,  /* mulops_calls */
        0,  /* wants_callb */
        0,  /* wants_argb */
        1,  /* left_to_right */
        0,  /* wants_dag */
        1,  /* unsigned_char */
        address,
        blockbeg,
        blockend,
        defaddress,
        defconst,
        defstring,
        defsymbol,
        emit,
        export,
        function,
        gen,
        global,
        import,
        local,
        progbeg,
        progend,
        segment,
        space,
        0, 0, 0, stabinit, stabline, stabsym, 0,
        {
                2,      /* max_unaligned_load */
                rmap,
                blkfetch, blkstore, blkloop,
                _label,
                _rule,
                _nts,
                _kids,
                _string,
                _templates,
                _isinstruction,
                _ntname,
                emit2,
                doarg,
                target,
                clobber,

        }
};
static char rcsid[] =
	"$Header: /dist/lcc-xr16/src-mods/src/xr16.md 3     3/04/00 10:05a Jan $\n"
	"Portions copyright (C) 1999,2000, Gray Research LLC.  All rights reserved.\n"
	"This program is subject to the XSOC License Agreement.\n"
	"See the LICENSE file.";
